const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");

const HardwareCreditCustomerPayments = sequelizeConnect.define(
  "hardware_credit_customer_payments",
  {
    id: {
      type: Sequelize.UUID,
      defaultValue: Sequelize.UUIDV4,
      primaryKey: true,
      allowNull: false,
    },
    hardware_credit_customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    seller_company_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    reference_no: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    order_id: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    amount_paid: {
      type: Sequelize.DECIMAL(10, 4),
      allowNull: false,
    },
    file_attach: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    status: {
      type: Sequelize.STRING,
      allowNull: false,
      defaultValue: "Verified",
    },
  }
);

module.exports = HardwareCreditCustomerPayments;
