const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const HardwareCredit = sequelizeConnect.define(
  "hardware_credit",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    seller_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    reference_no: {
        type: Sequelize.STRING(150),
        allowNull: false,
    },
    amount: {
        type: Sequelize.DECIMAL(10, 2),
        allowNull: false,
        defaultValue: 0.00
    },
    status: {
        type: Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    }
},
{
    tableName: "hardware_credit",
    timestamps: true,
})

module.exports = HardwareCredit;
