const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ForogotPassword = sequelizeConnect.define(
  "forgot_password",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    token: {
        type: Sequelize.STRING(500),
        allowNull: false,
      },
    created_at: {
        type: Sequelize.DATE,
        allowNull: false,
      },
},
{
    tableName: "forgot_password",
    timestamps: false,
    
})

module.exports = ForogotPassword;
