const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const FeatureProducts = sequelizeConnect.define(
  "feature_products",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    menu_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    branch_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    pickup_location_id: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      special_products: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
      vendor: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
    
},
{
    tableName: "feature_products",
    timestamps: false,
    
})

module.exports = FeatureProducts;