const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Drivers = sequelizeConnect.define(
  "driver",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    logistics_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    name: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    address: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    username: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },   
    password: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },  

},

{
    tableName: "driver",
    timestamps: false,
    
})

module.exports = Drivers;
