const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const DetailSellerReviews = sequelizeConnect.define(
  "detail_seller_reviews",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
        type: Sequelize.BIGINT,
        allowNull: false,
    },
    rate: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            isIn: [[0, 1, 2, 3, 4, 5]],
        },
    },
    review: {
        type: Sequelize.STRING(200),
        allowNull: true,
    },
    timestamp: {
        type: Sequelize.DATE,
        allowNull: false,
    }

},
{
    tableName: "detail_seller_reviews",
    timestamps: false,
    
})

module.exports = DetailSellerReviews;
