const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");

const DetailProductReviews = sequelizeConnect.define(
  "detail_product_reviews",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    product_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    rate: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    reviews: {
      type: Sequelize.STRING(200),
      allowNull: false,
    },
    timestamp: {
      type: Sequelize.DATE,
      allowNull: false,
    },
  },
  {
    tableName: "detail_product_reviews",
    timestamps: false,
  }
);
DetailProductReviews.belongsTo(Customers, {
  foreignKey: "customer_id",
  as: "customer",
});

module.exports = DetailProductReviews;
