const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const SellersCompany = require("./SellersCompany");
const Products = require("./Products");

const CustomerQuotationDetails = sequelizeConnect.define(
  "customer_quotation_details",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    customer_quotation_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    item_name: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    quantity: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    internal_supplier: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    internal_product_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    unit_price: {
      type: Sequelize.DECIMAL(10, 6),
      allowNull: true,
    },
    total_price: {
      type: Sequelize.DECIMAL(10, 6),
      allowNull: true,
    },
    quotation_detail_status: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "customer_quotation_details",
    timestamps: false,
  }
);

CustomerQuotationDetails.belongsTo(SellersCompany, {
  foreignKey: "internal_supplier",
  as: "sellers_company",
});

CustomerQuotationDetails.belongsTo(Products, {
  foreignKey: "internal_product_id",
  as: "product",
});

module.exports = CustomerQuotationDetails;
