const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const CustomerQuotationDetails = require("./CustomerQuotationDetails");

const CustomerQuotation = sequelizeConnect.define(
  "customer_quotation",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    quotation_reference_no: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    longitude: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    latitude: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    address: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    shipping_fee: {
      type: Sequelize.DECIMAL(10, 6),
      defaultValue: 0,
      allowNull: true,
    },
    quotation_status: {
      type: Sequelize.STRING,
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "customer_quotation",
    timestamps: false,
  }
);

CustomerQuotation.hasMany(CustomerQuotationDetails, {
  foreignKey: "customer_quotation_id",
  as: "customer_quotation_details",
});
module.exports = CustomerQuotation;
