const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const CreditLimit = sequelizeConnect.define(
  "credit_limit",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    credit_limit: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00
    },
},
{
    tableName: "credit_limit",
    timestamps: false,
    
})

module.exports = CreditLimit;
