const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ConversationsLogistics = sequelizeConnect.define(
  "conversations_logistics",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    buyer_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    last_updated: {
      type: Sequelize.TIME,
      allowNull: false,
      defaultValue: Sequelize.literal('CURRENT_TIMESTAMP')
    },
  },
  {
    tableName: "conversations_logistics",
    timestamps: false, // Remove timestamps option
  }
);

module.exports = ConversationsLogistics;
