const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ConversationsAdmin = sequelizeConnect.define(
  "conversations_admin",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    buyer_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    admin_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    last_updated: {
      type: Sequelize.TIME,
      allowNull: false,
    },
  },
  {
    tableName: "conversations_admin",
    timestamps: false,
  }
);

module.exports = ConversationsAdmin;
