const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");
const SellersCompany = require("./SellersCompany");
const Customers = require("./Customers");

const Conversations = sequelizeConnect.define(
  "conversations",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    buyer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    last_updated: {
      type: Sequelize.TIME,
      allowNull: false,
    },
  },
  {
    tableName: "conversations",
    timestamps: false,
  }
);

Conversations.belongsTo(SellersCompany, {
  foreignKey: "seller_id",
  as: "seller_company",
});
Conversations.belongsTo(Customers, {
  foreignKey: "buyer_id",
  as: "customer_detail",
});

module.exports = Conversations;
