const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const ChatsLogistics = sequelizeConnect.define(
  "chats_logistics",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    conversation_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    buyer_id: {
        type: Sequelize.BIGINT,
        allowNull: true,
      },
    seller_id: {
        type: Sequelize.BIGINT,
        allowNull: true,
    },
    message: {
        type: Sequelize.STRING(300),
        allowNull: true,
    },
    created_on: {
        type: Sequelize.DATE,
        allowNull: false,
    },
    isSeen_buyer: {
        type: Sequelize.BIGINT,
        allowNull: true,
    },
    isSeen_seller: {
        type: Sequelize.BIGINT,
        allowNull: true,
    },
    isDeleted: {
      type: Sequelize.ENUM("True", "False"),
      allowNull: true,
  },
},
{
    tableName: "chats_logistics",
    timestamps: false,
    
})

module.exports = ChatsLogistics;
