const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");
const SellersCompany = require("./SellersCompany");
const Conversations = require("./Conversations");

const Chats = sequelizeConnect.define(
  "chats",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    conversation_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    buyer_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    seller_id: {
      type: Sequelize.BIGINT,
      allowNull: true,
    },
    message: {
      type: Sequelize.STRING(300),
      allowNull: false,
    },
    created_on: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    isSeen_buyer: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    isSeen_seller: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    isDeletedv: {
      type: Sequelize.ENUM("True", "False"),
      allowNull: true,
    },
  },
  {
    tableName: "chats",
    timestamps: false,
  }
);

// Define associations
Chats.belongsTo(Customers, { foreignKey: "buyer_id", as: "buyer" });
Chats.belongsTo(SellersCompany, { foreignKey: "seller_id", as: "seller" });
Chats.belongsTo(Conversations, {
  foreignKey: "conversation_id",
  as: "conversation_detail",
});
Conversations.hasMany(Chats, {
  foreignKey: "conversation_id",
  as: "chats_detail",
});

module.exports = Chats;
