const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const Customers = require("./Customers");
const SystemUser = require("./SystemUser");

const ChatConversationsAdmin = sequelizeConnect.define(
  "chats_buyer_admin",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    buyer_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    admin_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
    message: {
      type: Sequelize.STRING(300),
      allowNull: false,
    },
    created_on: {
      type: Sequelize.DATE,
      allowNull: false,
    },
    isSeen_Buyer: {
      type: Sequelize.INTEGER,
      allowNull: true,
    },
    isSeen_Admin: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    conversation_id: {
      type: Sequelize.INTEGER,
      allowNull: false,
    },
  },
  {
    tableName: "chats_buyer_admin",
    timestamps: false,
  }
);

ChatConversationsAdmin.belongsTo(Customers, {
  foreignKey: "buyer_id",
  as: "buyer",
});
ChatConversationsAdmin.belongsTo(SystemUser, {
  foreignKey: "admin_id",
  as: "admin",
});

module.exports = ChatConversationsAdmin;
