const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");

const BuildcreditOverpaymentsOrders = sequelizeConnect.define(
  "buildcredit_overpayments_orders",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    buildcredit_overpayments_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    order_id: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    order_reference_no: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    reference_no: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    amount_paid: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "buildcredit_overpayments_orders",
    timestamps: false,
  }
);

module.exports = BuildcreditOverpaymentsOrders;
