const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const BuildcreditOverPaymentsOrders = require("./BuildcreditOverPaymentsOrders");

const BuildcreditOverpayments = sequelizeConnect.define(
  "buildcredit_overpayments",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    reference_no: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    customer_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    buildcredit_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    amount: {
      type: Sequelize.DECIMAL(10, 2),
      allowNull: false,
    },
    datetime: {
      type: Sequelize.DATE,
      allowNull: false,
      defaultValue: new Date(),
    },
    is_pdc_payment: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    cheque_date: {
      type: Sequelize.DATEONLY,
      allowNull: true,
    },
    cheque_number: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    bank: {
      type: Sequelize.STRING(300),
      allowNull: true,
    },
    payment_status: {
      type: Sequelize.ENUM("Verified", "Denied", "Pending"),
      allowNull: false,
    },
    status: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
  },
  {
    tableName: "buildcredit_overpayments",
    timestamps: false,
  }
);

BuildcreditOverpayments.hasMany(BuildcreditOverPaymentsOrders, {
  foreignKey: "buildcredit_overpayments_id",
  as: "buildcredit_overpayment_orders",
});
BuildcreditOverPaymentsOrders.belongsTo(BuildcreditOverpayments, {
  foreignKey: "buildcredit_overpayments_id",
  as: "buildcredit_overpayment",
});

module.exports = BuildcreditOverpayments;
