const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const AutomationServicesLogs = sequelizeConnect.define(
  "automation_services_logs",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    automation_type: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    is_success: {
      type: Sequelize.BOOLEAN,
      allowNull: false,
    },
  },
  {
    tableName: "automation_services_logs",
    timestamps: true,
  }
);

module.exports = AutomationServicesLogs;
