const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const Announcements = sequelizeConnect.define(
  "announcements",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    title: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    description: {
      type: Sequelize.STRING(500),
      allowNull: false,
    },
    for_user: {
        type: Sequelize.STRING(500),
        allowNull: false,
      },
      created_at: {
        type: Sequelize.DATE,
        allowNull: false,
      },
      end_date: {
        type: Sequelize.DATEONLY,
        allowNull: false,
      },
    
},
{
    tableName: "announcements",
    timestamps: false,
    
})

module.exports = Announcements;
