const Sequelize = require("sequelize");
const sequelizeConnect = require("../connection/db");
const Customers = require("./Customers");

const AgentCustomer = sequelizeConnect.define(
  "agent_customer_list",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    agent: {
      type: Sequelize.STRING(150),
      allowNull: false,
    },
    customer: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
  },
  {
    tableName: "agent_customer_list",
    timestamps: false,
  }
);

AgentCustomer.belongsTo(Customers, {
  foreignKey: "customer",
  as: "customerAgent",
});

module.exports = AgentCustomer;
