const Sequelize = require("sequelize");
const bcryptjs = require("bcryptjs");
const sequelizeConnect = require("../connection/db");

const AdminAuthorizationToken = sequelizeConnect.define(
  "admin_authorization_token",
  {
    id: {
      type: Sequelize.BIGINT,
      primaryKey: true,
      allowNull: false,
      autoIncrement: true,
    },
    admin_user_id: {
      type: Sequelize.BIGINT,
      allowNull: false,
    },
    token: {
      type: Sequelize.STRING(300),
      allowNull: false,
    },
  },
  {
    tableName: "admin_authorization_tokens",
    timestamps: true,
  }
);

module.exports = AdminAuthorizationToken;
