exports.otpSenderTemplate = (otp_code, otp_reference_no) => {
  return (
    "Your OTP for BuildCredit Application is " +
    otp_code +
    ". This is valid for 5 minutes. DO NOT SHARE THIS WITH ANYONE. If you did not request an OTP, please email us at info.buildhub.ph. Reference #: " +
    otp_reference_no
  );
};

exports.orderPlaced = (customer_name, reference_no) => {
  return `
    Hi ${customer_name},
    Your Order Ref # ${reference_no} has been succesfully placed. If you didn't make this order, please contact us at 09171804591.
    `;
};

exports.orderVerified = (customer_name, reference_no) => {
  return `
  Good day ${customer_name}. Your Order Ref # ${reference_no} is verified and pending. If you didn't make this order, contact us at 09171804591.
  `;
};

exports.orderDenied = (customer_name, reference_no) => {
  return `
  Hi ${customer_name},
  Your Order Ref # ${reference_no} has been denied. If you didn't make this order, please contact us at 09171804591.`;
};

exports.orderPreparedDelivery = (customer_name, reference_no) => {
  return `
  Hi ${customer_name},
  Your Order Ref # ${reference_no} has been prepared for delivery. If you didn't make this order, please contact us at 09171804591.`;
};

exports.orderPreparedPickup = (customer_name, reference_no) => {
  return `
  Hi ${customer_name},
  Your Order Ref # ${reference_no} has been prepared for pick up. If you didn't make this order, please contact us at 09171804591.`;
};

exports.orderForDelivery = (customer_name, reference_no) => {
  return `
   Hi ${customer_name},
   Your Order Ref # ${reference_no} is now in delivery. If you didn't make this order, please contact us at 09171804591.
  `;
};

exports.orderPickedup = (customer_name, reference_no) => {
  return `
  Hi ${customer_name},
  Your Order Ref # ${reference_no} is now ready for pick up. If you didn't make this order, please contact us at 09171804591.`;
};

exports.buildCreditDraft = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  Warm Greetings! We noticed that your BuildCredit application is in draft. Please complete it as soon as possible so we can process it. If you need any assistance, feel free to reach out to us at 09171804591.
  `;
};

exports.buildCreditSubmitted = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  Warm Greetings! Thank you for submitting your BuildCredit application. We’re reviewing it and will get back to you soon with an update. If you need any assistance, feel free to reach out to us at 09171804591.
  `;
};

exports.buildCreditPending = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  Warm Greetings! Your BuildCredit application is currently pending. We’re processing it and will notify you as soon as there’s an update. If you need any assistance, feel free to reach out to us at 09171804591.
  `;
};

exports.buildCreditPendingOtherRequirements = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  Warm Greetings! We’re still waiting for additional requirements to complete your BuildCredit application. Please submit the remaining documents at your earliest convenience. If you need any assistance, feel free to reach out to us at 09171804591.
  `;
};

exports.buildCreditApproved = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name}. We're happy to inform that your BuildCredit application has been approved and you're eligible for a BPI loan. Have questions? Contact us at 09171804591.
  `;
};

exports.buildCreditCaseToCase = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  Warm Greetings! We’re happy to inform you that your BuildCredit application has been conditionally approved. Please contact us for more details on the specific terms. If you need any assistance, feel free to reach out to us at 09171804591.
  `;
};

exports.buildCreditDeclined = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name}. We regret to inform you that your BuildCredit application has been declined. Questions? Contact us at 09171804591.
  `;
};

exports.buildCreditSuspended = (customer_name, company_name) => {
  return `
  Hi ${customer_name} of ${company_name},
  We regret to inform you that your BuildCredit has been suspended. Have questions? Contact us at 09171804591.
  `;
};

exports.sellerWarehouseMenSmsTemplateOrderPlaced = (
  customer_name,
  company_name,
  reference_number,
  date,
  delivery = true
) => {
  return `
  Hi! Please prepare for ${
    delivery ? "delivery" : "pickup"
  }, Order Ref# ${reference_number}. Questions? Call 09171804591. Note: Not the official release order.
  `;
};
