const computeDistance = require("./computeDistance");
const logger = require("../util/logger");
async function checkSellerShipping(customerLat, customerLng, sellerLat, sellerLng, sellerShippingRadius) {
  if (!sellerLat || !sellerLng) {
    return { success: false, msg: "Seller location not set!" };
  }
  logger.error(`------------------CHECK SELLER SHIPPING------------------`);
  logger.error(
    `CUSTOMER LAT: ${customerLat}, CUSTOMER LNG: ${customerLng}, SELLER LAT: ${sellerLat}, SELLER LNG: ${sellerLng}`
  );
  const distance = await computeDistance(`${customerLat},${customerLng}`, `${sellerLat},${sellerLng}`);
  logger.error(`DISTANCE: ${distance}`);
  const enabledSellerShipping = distance <= sellerShippingRadius;
  logger.error(`ENABLED SELLER SHIPPING: ${enabledSellerShipping}`);
  logger.error(`------------------CHECK SELLER SHIPPING------------------`);

  return { seller_shipping_within_range: enabledSellerShipping, total_distance: distance };
}

module.exports = checkSellerShipping;
