const { sellerProductImageBuilder } = require("../helpers/image-src-builder");

const productMapper = (sellerProducts) => {
  let __sellerProducts = sellerProducts;
  if (!Array.isArray(sellerProducts)) {
    __sellerProducts = [sellerProducts];
  }

  const _sellerProducts = __sellerProducts.map(
    ({
      id,
      menu,
      description,
      price,
      discounted_price,
      photo,
      quantity_limit,
      stocks,
      available,
      sku,
      menus,
      seller_dashboard_src,
      product_variations,
      product_images,
    }) => {
      const response = {
        id,
        name: menu,
        description,
        price,
        discounted_price,
        photo: [],
        quantity_limit,
        stocks,
        available,
        sku,
        category: menus,
        seller_dashboard_src,
      };

      if (photo !== null && photo !== "")
        response.photo.push({ photo: sellerProductImageBuilder(photo, seller_dashboard_src) });

      product_images.map(({ id, file_name }) => {
        if (file_name !== "" || file_name !== null)
          response.photo.push({
            id,
            photo: sellerProductImageBuilder(file_name, true),
          });
      });

      const productVariation = product_variations.map(
        ({
          id,
          variation,
          description,
          quantity_limit,
          discounted_price,
          hasSubVariation,
          isAvailable,
          variationImage,
          sku,
          stocks,
          ProductSubVariations,
        }) => {
          const response = {
            id,
            name: variation,
            description,
            quantity_limit,
            discounted_price,
            has_sub_variation: hasSubVariation,
            is_available: isAvailable,
            photo:
              variationImage !== null && variationImage !== "" && variationImage
                ? sellerProductImageBuilder(variationImage, true)
                : null,
            sku,
            stocks,
          };

          const productSubVariation = ProductSubVariations.map(
            ({
              id,
              custom,
              description,
              price,
              discounted_price,
              quantity_limit,
              stocks,
              sku,
              isAvailable,
              photo,
            }) => ({
              id,
              name: custom,
              description,
              price,
              discounted_price,
              quantity_limit,
              stocks,
              sku,
              is_available: isAvailable,
              photo: photo !== "" && photo !== null && photo ? sellerProductImageBuilder(photo, true) : null,
            })
          );

          response.product_sub_variations = productSubVariation;
          return response;
        }
      );

      response.product_variations = productVariation;
      return response;
    }
  );

  return _sellerProducts;
};

module.exports = productMapper;
