const marketplaceSettings = require("../marketplace.json");

const sellerImageBuilder = (fileName, newSrc = true) => {
  if (!fileName || fileName === "" || fileName === null) return null;
  let imageSrcUrl = marketplaceSettings.ASSETS_SELLER_URL_V1;
  if (newSrc) {
    imageSrcUrl = marketplaceSettings.ASSETS_SELLER_URL_V2;
  }

  return `${imageSrcUrl}${fileName}`;
};

const sellerProductImageBuilder = (fileName, newSrc = true) => {
  if (!fileName || fileName === "" || fileName === null) return null;

  let imageSrcUrl = marketplaceSettings.ASSETS_PRODUCTS_URL_V1;
  if (newSrc) {
    imageSrcUrl = marketplaceSettings.ASSETS_PRODUCTS_URL_V2;
  }

  return `${imageSrcUrl}${fileName}`;
};

const customerAttachmentProofBuilder = (fileName, newSrc = true) => {
  if (!fileName || fileName === "" || fileName === null) return null;

  let imageSrcUrl = marketplaceSettings.ASSETS_ATTACHMENT_URL_V1;
  if (newSrc) {
    imageSrcUrl = marketplaceSettings.ASSETS_ATTACHMENT_URL_V2;
  }

  return `${imageSrcUrl}${fileName}`;
};

const sellerReleaseOrderBuilder = (fileName, newSrc = true) => {
  if (!fileName || fileName === "" || fileName === null) return null;

  let imageSrcUrl = marketplaceSettings.ASSETS_RELEASE_ORDER_V1;
  if (newSrc) {
    imageSrcUrl = marketplaceSettings.ASSETS_RELEASE_ORDER_V2;
  }

  return `${imageSrcUrl}${fileName}`;
};

module.exports = {
  sellerImageBuilder,
  sellerProductImageBuilder,
  customerAttachmentProofBuilder,
  sellerReleaseOrderBuilder,
};
