const { getCurrentDateTimeInGMT8 } = require("../common");
const orderConfirmation = async (reference_no, orderSummaryHTML, total, shipping_type) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  return `
      <div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
        <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
          <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
            <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <div style="flex: 1;">
              <h1 style="color: #333; font-size: 24px; margin: 0;">You're almost there!</h1>
              <h1 style="color: #333; font-size: 24px; margin: 0;">Please wait for order confirmation.</h1>
              <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
              <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Order #: ${reference_no}</p>
            </div>
          </div>
          <div style="border-top: 1px solid #ccc; border-bottom: 1px solid #ccc; padding: 10px 0; margin-bottom: 20px;">
            <h2 style="color: #333; font-size: 20px; margin: 0;">Order Summary</h2>
            ${orderSummaryHTML}
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <p style="color: #666; font-size: 16px; margin: 0;">Total:</p>
            <p style="color: #333; font-size: 18px; margin: 0;">${total}</p>
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <p style="color: #666; font-size: 16px; margin: 0;">Shipping Type:</p>
            <p style="color: #333; font-size: 18px; margin: 0;">${shipping_type}</p>
          </div>
          <p style="color: #666; font-size: 16px; margin-top: 20px;">We will process your order shortly.</p>
          <p style="font-size: 16px; margin: 10px 0 20px;">Thank you for shopping with us!</p>
          <div style="text-align: center;">
            <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
          </div>
        </div>
      </div>
    `;
};

const orderSuccessfulWaitingOrderConfirmation = async (reference_no, orderSummaryHTML, total, shipping_type) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  return `
      <div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
        <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
          <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
            <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <div style="flex: 1;">
              <h1 style="color: #333; font-size: 24px; margin: 0;">Order has been successful placed!</h1>
              <h1 style="color: #333; font-size: 24px; margin: 0;">Please wait for order confirmation.</h1>
              <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
              <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Order #: ${reference_no}</p>
            </div>
          </div>
          <div style="border-top: 1px solid #ccc; border-bottom: 1px solid #ccc; padding: 10px 0; margin-bottom: 20px;">
            <h2 style="color: #333; font-size: 20px; margin: 0;">Order Summary</h2>
            ${orderSummaryHTML}
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <p style="color: #666; font-size: 16px; margin: 0;">Total:</p>
            <p style="color: #333; font-size: 18px; margin: 0;">${total}</p>
          </div>
          <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <p style="color: #666; font-size: 16px; margin: 0;">Shipping Type:</p>
            <p style="color: #333; font-size: 18px; margin: 0;">${shipping_type}</p>
          </div>
          <p style="color: #666; font-size: 16px; margin-top: 20px;">We will process your order shortly.</p>
          <p style="font-size: 16px; margin: 10px 0 20px;">Thank you for shopping with us!</p>
          <div style="text-align: center;">
            <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
          </div>
        </div>
      </div>
    `;
};

const adminOrderVerification = async (order_reference_no) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  console.log(dateNow);
  return `<div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
          <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
            <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
              <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
            </div>
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
              <div style="flex: 1;">
                <h1 style="color: #333; font-size: 24px; margin: 0;">Payment Confirmation</h1>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to inform that the payment for <b>Order Reference #: ${order_reference_no}</b> has been verified. </p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">If you have any questions, please reach out to info@buildhub.ph and we will be in touch shortly. </p>
              </div>
            </div>
            <p style="font-size: 16px; margin: 10px 0 20px;">Thank you for shopping with us!</p>
            <div style="text-align: center;">
              <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
            </div>
          </div>
        </div>`;
};

const verificationEmailRegister = (token) => {
  return `
  <html>
  <head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .logo img {
            max-width: 200px;
            height: auto;
        }

        h2 {
            color: #333;
            text-align: center;
        }

        p {
            color: #666;
            line-height: 1.5;
            margin-bottom: 20px;
        }

        .token {
            background-color: #007bff;
            color: #fff;
            padding: 15px;
            border-radius: 5px;
            text-align: center;
            font-size: 18px;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo">
        </div>
        <h2>Verify Your Email Address</h2>
        <p>Welcome to BuildHub! please use this verification code to verify your email address:</p>
        <div class="token">${token}</div>
        <p>If you did not create an account on BuildHub, you can safely ignore this email.</p>
        <p class="footer">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
    </div>
</body>
</html>
`;
};

const passwordResetEmail = (token) => {
  return `
  <!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            text-align: center; /* Center all text */
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            text-align: left; /* Reset text alignment */
        }

        .logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .logo img {
            max-width: 200px;
            height: auto;
        }

        h2 {
            color: #333;
            text-align: center;
        }

        p {
            color: #666;
            line-height: 1.5;
            margin-bottom: 20px;
            text-align: center;
        }

        .button-container {
            text-align: center;
            margin-bottom: 20px;
        }

        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #dc3545;
            color: white ! important;
            text-decoration: none;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }

        .button:hover {
            background-color: #c82333;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo">
        </div>
        <h2>Forgot Password</h2>
        <p>Welcome to BuildHub! Please click the forgot password button to reset your password:</p>
        <div class="button-container">
            <a href="https://buildhub.ph/forgot-password?token=${token}" class="button">Forgot Password</a>
        </div>
        <p class="footer">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
    </div>
</body>
</html>
   `;
};

const _verificationEmailRegister = (token) => {
  return `
  <html>
<head>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      margin: 0;
      padding: 0;
    }

    .container {
      max-width: 600px;
      margin: 0 auto;
      padding: 20px;
      background-color: #fff;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
      text-align: center; /* Center all text */
    }

    .logo {
      margin-bottom: 20px;
    }

    .logo img {
      max-width: 200px;
      height: auto;
    }

    h2 {
      color: #333;
    }

    p {
      color: #666;
      line-height: 1.5;
      margin-bottom: 20px;
    }

    .button-container {
      margin-bottom: 20px;
    }

    .button {
      background-color: #ff0000; /* Red background */
      color: white ! important; /* White text */
      padding: 15px 30px;
      border-radius: 5px;
      font-size: 18px;
      text-decoration: none;
    }

    .button:hover {
      background-color: #cc0000; /* Darker red on hover */
    }

    .footer {
      margin-top: 20px;
      font-size: 14px;
    }

    .link {
      color: white; /* White text for the link */
      text-decoration: none; /* Remove default underline */
    }

    .link:hover {
      text-decoration: underline; /* Add underline on hover */
    }
  </style>
</head>
<body>
<div class="container">
  <div class="logo">
    <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo">
  </div>
  <h2>Verify Your Email Address</h2>
  <p>Welcome to BuildHub! Please click the button below to verify your account:</p>
  <div class="button-container">
    <a href="https://api.buildhubware.com/api/v1/accounts/verify-email/${token}" class="button">Verify Email</a>
  </div>
  <p>If you did not create an account on BuildHub, you can safely ignore this email.</p>
  <p class="footer">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
</div>
</body>
</html>

`;
};

const buildCreditMailTemplate = async (contact_person, company_name, credit_limit, credit_term, application_status) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  const applicationStatus = application_status.toLowerCase();

  let applicationLine = "";
  switch (applicationStatus) {
    case "approved":
      applicationLine = `<p style="color: #666; margin: 5px 0 0; font-size: 14px;">Congratulations! This is to inform you that your company <b>${company_name}</b> application to BuildCredit has been <b>${application_status}</b>. With a credit limit of <b>PHP${credit_limit}</b> and maximum term of <b>${credit_term}</b>.</p>`;
      break;
    case "declined":
      applicationLine = `<p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to inform you that your company <b>${company_name} application to BuildCredit has been <b>${application_status}</b>.</p>`;
      break;
    case "suspended":
      applicationLine = `<p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to inform you that your company <b>${company_name} application to BuildCredit has been <b>${application_status}</b>.</p>`;
      break;
    default:
      applicationLine = `<p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to inform you that your company <b>${company_name} application to BuildCredit has been <b>${application_status}</b>.</p>`;
      break;
  }
  return `<div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
          <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
            <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
              <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
            </div>
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
              <div style="flex: 1;">
                <h1 style="color: #333; font-size: 24px; margin: 0;">BuildCredit Application</h1>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Dear ${contact_person},</p>
                ${applicationLine}
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">If you have any questions, please reach out to info@buildhub.ph and we will be in touch shortly. </p>
              </div>
            </div>
            <div style="text-align: center;">
              <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
            </div>
          </div>
        </div>`;
};

const buildCreditApplicationAcknowledgement = async (contact_person) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  return `<div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
          <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
            <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
              <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
            </div>
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
              <div style="flex: 1;">
                <h1 style="color: #333; font-size: 24px; margin: 0;">BuildCredit Application</h1>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Dear ${contact_person},</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to acknowledge the receipt of your BuildCredit application. We will email you regarding your application.</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">If you have any questions, please reach out to info@buildhub.ph and we will be in touch shortly. </p>
              </div>
            </div>
            <div style="text-align: center;">
              <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
            </div>
          </div>
        </div>`;
};

const sellerReleaseOrderEmail = async (reference_no, customer_name, order_status, isPickup, order_address) => {
  const dateNow = new Date(await getCurrentDateTimeInGMT8()).toDateString();
  const addressLine = isPickup
    ? `Pick-Up Address: <b>${order_address}</b>`
    : `Delivery Address: <b>${order_address}</b>`;
  const emailLine = `<p style="color: #666; margin: 5px 0 0; font-size: 14px;">${addressLine}</p>`;

  return `<div style="font-family: Arial, sans-serif; padding: 20px; background-color: #f9f9f9; border-radius: 10px;">
          <div style="background-color: #ffffff; border-radius: 10px; padding: 20px; box-shadow: 0px 0px 10px 0px rgba(0,0,0,0.1);">
            <div style="display: flex; justify-content: center; align-items: center; margin-bottom: 20px;">
              <img src="https://buildhub.ph/img/buildhub.png" alt="BuildHub Logo" style="max-width: 150px; max-height: 150px;">
            </div>
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
              <div style="flex: 1;">
                <h1 style="color: #333; font-size: 24px; margin: 0;">Order Status Update</h1>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Date: ${dateNow}</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Dear ${customer_name},</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">Order #: ${reference_no}</p>
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">This is to inform you that your order status is <b>${order_status}</b>.</p>
                ${emailLine}
                <p style="color: #666; margin: 5px 0 0; font-size: 14px;">If you have any questions, please reach out to info@buildhub.ph and we will be in touch shortly. </p>
              </div>
            </div>
            <div style="text-align: center;">
              <p style="color: #999; font-size: 12px; margin: 0;">This email was sent by BuildHub. &copy; 2024 All Rights Reserved.</p>
            </div>
          </div>
        </div>`;
};

module.exports = {
  orderConfirmationHtml: orderConfirmation,
  orderSuccessfulWaitingOrderConfirmation,
  adminOrderVerification,
  verificationEmailRegister,
  _verificationEmailRegister,
  passwordResetEmail,
  buildCreditMailTemplate,
  buildCreditApplicationAcknowledgement,
  sellerReleaseOrderEmail,
};
