function formatAmount(amount) {
  try {
    let parsed_amount = parseFloat(amount);

    if (isNaN(parsed_amount)) {
      return 0;
    }

    let formatted_amount = parsed_amount.toLocaleString("en-US", { minimumFractionDigits: 2 });

    return formatted_amount;
  } catch (error) {
    return 0;
  }
}

const verifyEmailTemplate = (user_name, token) => {
  return `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://buildhub.ph/assets/main-logo-DTvvOuK0.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">Please Verify your Email Address</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px; font-size: 20px;">
                    <td style=" padding-left: 10px; margin-top: -10px; text-align: left;">Welcome to Buildhub.ph!</td>
                </div>
            </div>
           
            <div style="padding-top: 40px; padding-bottom: 40px; ">
                <p style="background-color: red; padding: 10px; border-radius: 10px; width: 120px; margin: auto;">
                    <span><a href="https://api.buildhubware.com/api/v1/accounts/verify-email/${token}" style="color: white;">Verify Email </a></span>
                </p>
                <p style="font-size: 15px; opacity: 0.2;">Click the button below to verify your account </p>
                <p>If you did not create an account on BuildHub <br> please ignore this email. Thank You! </p>
            </div>
            <div>
                <p>Looking for financing solution?
                    <span><a href="https://buildhub.ph" style="color: red;">Apply Now to BuildCredit!</a></span>
                </p>
            
            
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                   
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;
};

const readyForPickupTemplate = (user_name, reference_no) => {
  return `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER READY TO PICK UP</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p> This is to inform you that your order with reference no. ${reference_no} is ready for pick up.</p>
                
            </div>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;
};

const readyForDeliveryTemplate = (user_name, reference_no) => {
  return `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER READY FOR DELIVERY</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p> We are happy to inform you that your order with the reference no. ${reference_no} is ready for delivery.</p>
                <p>Click here to track your order. 
                    <span><a href="https://buildhub.ph/TrackOrder">Track Order </a></span>
                </p>
            </div>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;
};

const preparingOrdersTemplate = (reference_no, order_summary, product_details) => {
  let productDetails = ``;

  const isCustomerPickup = order_summary.shipping_type === "Pick-up";
  if (product_details.length > 0) {
    product_details.forEach((productDetail) => {
      productDetails += `
           <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                    </td>
                    <td style="text-align: right; padding: 8px;">
                        <p style="margin-top: 10px;">${productDetail.menu}</p>
                        <p style="margin-top: -10px; padding-bottom: 50px;">QTY: ${productDetail.qty} </p>
                        <p style="font-weight: bold;">PRICE: ${formatAmount(productDetail.price)} </p>
                    </td>
                </tr>
            `;
    });
  }

  const main = `
  <html>
  <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">PREPARING ORDER</h2>
                <p> Hi, seller is now preparing your order for ${
                  isCustomerPickup ? "pick up" : "delivery"
                } with the reference no. ${reference_no}.</p>
            </div>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <th style="text-align: left; padding: 8px;">Order Summary</th>
                    <th style="font-weight:100; opacity: 0.5; text-align:right; padding: 8px;">Estimate Delivery: 5-7 days</th>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Order ID:</td>
                    <td style=" text-align: right; padding: 8px;">${reference_no}</td>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Date & Time:</td>
                    <td style=" text-align: right; padding: 8px;">${order_summary.date_created}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Discount Voucher:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.voucher_amount)}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Shipping fee:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.shipping_fee)}</td>
                </tr>
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Total Price:</td>
                    <td style="text-align: right; padding: 8px;">P${formatAmount(order_summary.total_amount)}</td>
                </tr>
            </table>
            <table style="width: 100%; border-collapse: collapse;">
                ${productDetails}
            </table>
            <div style="text-align: left; font-weight: bold;">
                <p>Shipping Details</p>
            </div>
            <table style="margin-top: -20px;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                        <img src="https://devdojo.cloud/buildhub/img/carbon--location.png" width="20" height="20" style="margin-bottom: 30px; opacity: 0.2;" alt="sample-picture">
                    </td>
                    <td>
                        <p style=" text-align: left; opacity: 0.2;">${
                          isCustomerPickup
                            ? `${order_summary.customer_address}`
                            : `Seller ${order_summary.seller_name}: ${order_summary.seller_address}`
                        }</p>
                    </td>
                    
                </tr>
            </table>
            
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="product-image"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
            </table>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
  </html>
  `;

  return main;
};

const adminVerifiedOrder = (user_name, reference_no) => {
  return `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER VERIFIED</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p> This is to inform you that your order with reference no. ${reference_no} has been verified.</p>
                
            </div>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;
};

const orderPlacedTemplate = (reference_no, order_summary, product_details) => {
  let productDetails = ``;

  if (product_details.length > 0) {
    product_details.forEach((productDetail) => {
      productDetails += `
           <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                    </td>
                    <td style="text-align: right; padding: 8px;">
                        <p style="margin-top: 10px;">${productDetail.menu}</p>
                        <p style="margin-top: -10px; padding-bottom: 50px;">QTY: ${productDetail.qty} </p>
                        <p style="font-weight: bold;">PRICE: ${formatAmount(productDetail.price)} </p>
                    </td>
                </tr>
            `;
    });
  }
  const main = `
  <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER PLACED</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${order_summary.name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <th style="text-align: left; padding: 8px;">Order Summary</th>
                    <th style="font-weight:100; opacity: 0.5; text-align:right; padding: 8px;">Estimate Delivery: 5-7 days</th>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Order ID:</td>
                    <td style=" text-align: right; padding: 8px;">${reference_no}</td>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Date & Time:</td>
                    <td style=" text-align: right; padding: 8px;">${order_summary.date_created}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Discount Voucher:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.voucher_amount)}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Shipping fee:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.shipping_fee)}</td>
                </tr>
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Total Price:</td>
                    <td style="text-align: right; padding: 8px;">P${formatAmount(order_summary.total_amount)}</td>
                </tr>
            </table>
            <table style="width: 100%; border-collapse: collapse;">
                ${productDetails}
            </table>
            <div style="text-align: left; font-weight: bold;">
                <p>Shipping Details</p>
            </div>
            <table style="margin-top: -20px;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                        <img src="https://devdojo.cloud/buildhub/img/carbon--location.png" width="20" height="20" style="margin-bottom: 30px; opacity: 0.2;" alt="sample-picture">
                    </td>
                    <td>
                        <p style=" text-align: left; opacity: 0.2;">Seller ${order_summary.seller_name}: ${
    order_summary.seller_address
  }</p>
                    </td>
                    
                </tr>
            </table>
            <table style="margin-top: -20px;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                        <img src="https://devdojo.cloud/buildhub/img/carbon--location.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture">
                    </td>
                    <td>
                        <p style=" text-align: left;">${order_summary.customer_address}</p>
                    </td>
                </tr>
            </table>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
            </table>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
</html>
    `;
  return main;
};

const adminDeniedOrder = (user_name, reference_no) => {
  return `
  <html>
        <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER DENIED</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p> We regret to inform you that your order with the reference no. ${reference_no} has been decline.</p>
                
            </div>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
</html>
    `;
};

const orderDeliveredTemplate = (reference_no, order_summary, product_details) => {
  let productDetails = ``;

  if (product_details.length > 0) {
    product_details.forEach((productDetail) => {
      productDetails += `
           <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                    </td>
                    <td style="text-align: right; padding: 8px;">
                        <p style="margin-top: 10px;">${productDetail.menu}</p>
                        <p style="margin-top: -10px; padding-bottom: 50px;">QTY: ${productDetail.qty} </p>
                        <p style="font-weight: bold;">PRICE: ${formatAmount(productDetail.price)} </p>
                    </td>
                </tr>
            `;
    });
  }
  const main = `
  <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER DELIVERED</h2>
            </div>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <th style="text-align: left; padding: 8px;">Order Summary</th>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Order ID:</td>
                    <td style=" text-align: right; padding: 8px;">${reference_no}</td>
                </tr>
                <tr>
                    <td style=" text-align: left; opacity: 0.5; padding: 8px;">Date & Time Delivered:</td>
                    <td style=" text-align: right; padding: 8px;">${order_summary.date_delivered}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Discount Voucher:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.voucher_amount)}</td>
                </tr>
                <tr>
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Shipping fee:</td>
                    <td style="text-align: right; padding: 8px;">${formatAmount(order_summary.shipping_fee)}</td>
                </tr>
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; opacity: 0.5; padding: 8px;">Total Price:</td>
                    <td style="text-align: right; padding: 8px;">P${formatAmount(order_summary.total_amount)}</td>
                </tr>
            </table>
            <table style="width: 100%; border-collapse: collapse;">
                ${productDetails}
            </table>
            <div style="text-align: left; font-weight: bold;">
                <p>Shipping Details</p>
            </div>
            <table style="margin-top: -20px;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                        <img src="https://devdojo.cloud/buildhub/img/carbon--location.png" width="20" height="20" style="margin-bottom: 30px; opacity: 0.2;" alt="sample-picture">
                    </td>
                    <td>
                        <p style=" text-align: left; opacity: 0.2;">Seller ${order_summary.seller_name}: ${
    order_summary.seller_address
  }</p>
                    </td>
                    
                </tr>
            </table>
            <table style="margin-top: -20px;">
                <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                    <td style="text-align: left; padding: 8px;">
                        <img src="https://devdojo.cloud/buildhub/img/carbon--location.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture">
                    </td>
                    <td>
                        <p style=" text-align: left;">SUCCESSFULLY DELIVERED</p>
                    </td>
                </tr>
            </table>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
            </table>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
</html>
    `;
  return main;
};

const orderReadyTemplate = (user_name, reference_no) => {
  return `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER IS NOW READY!</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${user_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p>This is to inform you that your order with the reference no. ${reference_no} has been prepared.</p>
                
            </div>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;
};

const accountVerifiedTemplate = (user_name) => {
  return `
    <!DOCTYPE html>
    <html lang="en">
    <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Verification</title>
    </head>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

    <div style="max-width: 600px; margin: 20px auto; padding: 20px;">

        <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
            <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
        </div>

        <div style="padding: 20px; background-color: white; margin-bottom: 20px;">
            <div style="align-items: center; justify-content: center; text-align: center;">
                <div style="padding-bottom: 20px;">
                    <h2 style="margin: 0;">Welcome!</h2>
                </div>
                <div style="text-align: left;">
                    <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                        <td>Hey ${user_name}</td>
                    </div>
                    <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                        <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR SHOPPING WITH US!</td>
                    </div>
                </div>
            
                <div style="padding-top: 40px; padding-bottom: 40px;">
                    <img src="https://devdojo.cloud/buildhub/img/verified.png" width="100" height="100" style="margin-top: 10px;" alt="sample-picture">
                    <p style="font-weight: bold; font-size: 20px;">ACCOUNT VERIFIED </p>
                    <p>This is to inform you that your account has been verified. </p>
                    <p>Click here to login your account.
                        <span><a href="#">Login</a></span>
                    </p>
                </div>
                <div>
                    <p>Looking for financing solution?
                        <span><a href="https://buildhub.ph/login" style="color: red;">Apply Now!</a></span>
                    </p>
                
                
                <div style="border: 1px solid rgb(222, 222, 222);"></div>
                <div style="padding-bottom: 10px;"></div>
                <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                    <p style="opacity: 0.5;"> Any Inquiries? Contact Us at 09951670696</p>
                </div>
                <table style="border-collapse: collapse; width: 100%;">
                    <tr>
                        <th style="align-items: center;">
                            <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                            <td style="text-align: left;">Buildhub.ph</td>
                        </th>
                        <th>
                            <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                            <td style="text-align: left;">Buildhub.ph</td>
                        </th>
                        <th>
                            <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                            <td style="text-align: left;">Buildhub.ph</td>
                        </th>
                        <th>
                            <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                            <td style="text-align: left;">Buildhub.ph</td>
                        </th>
                    </tr>
            </div>
        </div>
        <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
            <p>Thank you for your order!</p>
        </div>
    </div>
    </body>
    </html>

    `;
};

const orderPickedUpTemplate = (reference_no, order_summary, product_details) => {
  let productDetails = ``;

  if (product_details.length > 0) {
    product_details.forEach((productDetail) => {
      productDetails += `
             <tr style="border-bottom: 1px solid rgb(207, 207, 207);">
                      <td style="text-align: left; padding: 8px;">
                      </td>
                      <td style="text-align: right; padding: 8px;">
                          <p style="margin-top: 10px;">${productDetail.menu}</p>
                          <p style="margin-top: -10px; padding-bottom: 50px;">QTY: ${productDetail.qty} </p>
                          <p style="font-weight: bold;">PRICE: ${formatAmount(productDetail.price)} </p>
                      </td>
                  </tr>
              `;
    });
  }

  const main = `
    <html>
    <body style="margin: 0; padding: 0; font-family: Arial, sans-serif; line-height: 1.6; background-color: #f9f9f9;">

<div style="max-width: 600px; margin: 20px auto; padding: 20px;">

    <div style="color: white; padding: 10px; text-align: center; margin-bottom: 20px;">
        <img src="https://devdojo.cloud/buildhub/img/buildhub.png" alt="BuildHub Logo" style="max-width: 100%;">
    </div>

    <div style="padding: 20px; background-color: #ececec; margin-bottom: 20px;">
        <div style="align-items: center; justify-content: center; text-align: center;">
            <div style="padding-bottom: 20px;">
                <h2 style="margin: 0;">ORDER PICKED UP</h2>
            </div>
            <div style="text-align: left;">
                <div style="background-color: #F8F8F8; padding-left: 20px; font-size: 17px; text-align: left; font-weight: bold; padding-top: 20px;">
                    <td>Hey ${order_summary.customer_name}</td>
                </div>
                <div style="background-color: #F8F8F8; padding-left: 20px; padding-bottom: 20px;">
                    <td style="padding-left: 10px; margin-top: -10px; text-align: left; ">THANK YOU FOR BUILDING WITH US!</td>
                </div>
            </div>
            <div style="padding-top: 40px; padding-bottom: 40px;">
                <p> We are happy to inform you that your order with the reference no. <b>${reference_no} has been picked up.</b></p>
                
            </div>
            <table style="width: 100%; border-collapse: collapse;">
                <th style="text-align: left; padding: 8px;">Order Summary</th>
                ${productDetails}
            </table>
            <div style="border: 1px solid rgb(222, 222, 222);"></div>
            <div style="padding-bottom: 10px;"></div>
            <div style="align-items: center; background-color: #F8F8F8; padding: 2px;"> 
                <p style="opacity: 0.5;">We hope you will order from us again.</p>
                <p style="opacity: 0.5;">Any Inquiries? Contact Us at <b>09951670696</b></p>
            </div>
            <table style="border-collapse: collapse; width: 100%;">
                <tr>
                    <th style="align-items: center;">
                        <td><img src="https://devdojo.cloud/buildhub/img/mdi--web.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ri--facebook-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/ic--baseline-tiktok.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                    <th>
                        <td><img src="https://devdojo.cloud/buildhub/img/akar-icons--linkedin-fill.png" width="20" height="20" style="margin-top: 10px;" alt="sample-picture"></td>
                        <td style="text-align: left;">Buildhub.ph</td>
                    </th>
                </tr>
        </div>
    </div>
    <div style="text-align: center; margin-top: 20px; font-size: 14px; color: #666;">
        <p>Thank you for your order!</p>
    </div>
</div>
</body>
    </html>
    `;

  return main;
};

module.exports = {
  verifyEmailTemplate,
  readyForPickupTemplate,
  readyForDeliveryTemplate,
  preparingOrdersTemplate,
  adminVerifiedOrder,
  orderPlacedTemplate,
  adminDeniedOrder,
  orderDeliveredTemplate,
  orderReadyTemplate,
  accountVerifiedTemplate,
  orderPickedUpTemplate,
};
