const crypto = require("crypto-js");
const axios = require("axios");
const moment = require("moment");

function generateRandomString() {
  const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  let result = "";
  for (let i = 0; i < 5; i++) {
    result += characters.charAt(Math.floor(Math.random() * characters.length));
  }
  return result;
}

function generateRandomNumber() {
  const min = 10000;
  const max = 99999;
  return Math.floor(Math.random() * (max - min + 1)) + min;
}
function removeSpecialCharactersAndSpaces(str) {
  return str.replace(/[^\w\s]/gi, "").replace(/\s/g, "");
}

function generateSecureRandomSixDigit() {
  const randomValue = Math.random().toString();

  const hashedValue = crypto.SHA256(randomValue);

  const hexString = hashedValue.toString(crypto.enc.Hex);

  const sixDigitOTP = parseInt(hexString.substring(0, 6), 16);

  return sixDigitOTP;
}

async function getCurrentDateTimeInGMT8() {
  try {
    // const response = await axios.get("https://worldtimeapi.org/api/timezone/Asia/Manila");
    // const timeDetail = response.data;
    return new Date();
  } catch (err) {
    console.error(err);
    throw err;
  }
}

function filterAndFormatPhones(phones) {
  return phones
    .filter((phone) => phone && phone !== "")
    .map((phone) => {
      if (phone.startsWith("+63")) {
        phone = phone.slice(1); // Remove the '+'
      } else if (phone.startsWith("0")) {
        phone = "63" + phone.slice(1);
      } else if (phone.startsWith("9")) {
        phone = "63" + phone;
      }
      return phone.length > 12 ? phone.slice(0, 12) : phone;
    });
}

const formatDate12Hour = (date) => {
  const options = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
    hour: "2-digit",
    minute: "2-digit",
    second: "2-digit",
    hour12: true,
  };

  return new Intl.DateTimeFormat("en-US", options).format(date);
};

const formatDateWithoutTime = (date) => {
  const options = {
    year: "numeric",
    month: "2-digit",
    day: "2-digit",
  };

  return new Intl.DateTimeFormat("en-US", options).format(date);
};

const isValidDate = (date) => {
  const dateRegex = /^\d{4}-\d{2}-\d{2}$/;
  if (!dateRegex.test(date)) {
    return false;
  }

  return moment(date, "YYYY-MM-DD", true).isValid();
};

function formatEncodeDate(dateString, isUTC = false) {
  if (dateString) {
    return dateString.toLocaleString("en-US", {
      year: "numeric",
      month: "long",
      day: "numeric",
      hour: "numeric",
      minute: "numeric",
      hour12: true,
      ...(isUTC && { timeZone: "UTC" }),
    });
  } else {
    return dateString;
  }
}

function generateRandomWords(numWords) {
  const words = [];
  const letters = "abcdefghijklmnopqrstuvwxyz";

  function getRandomWord() {
    const wordLength = Math.floor(Math.random() * 7) + 3; // Word length between 3 and 9
    let word = "";
    for (let i = 0; i < wordLength; i++) {
      word += letters.charAt(Math.floor(Math.random() * letters.length));
    }
    return word;
  }

  for (let i = 0; i < numWords; i++) {
    words.push(getRandomWord());
  }

  return words;
}

// const isBase64 = (str) => {
//   if (!str || typeof str !== 'string') return false;

//   // Base64 regex pattern (allows padding with = but not required)
//   const base64Regex = /^[A-Za-z0-9+/]+={0,2}$/;

//   if (!base64Regex.test(str) || str.length % 4 !== 0) {
//     return false; // Not Base64
//   }

//   try {
//     const decoded = Buffer.from(str, 'base64').toString('utf-8');
    
//     // Ensure decoding doesn't result in binary or garbled text
//     return decoded.trim().length > 0;
//   } catch (err) {
//     return false;
//   }
// };

function isBase64(str) {
  const base64Regex = /^(?:[A-Za-z0-9+\/]{4})*(?:[A-Za-z0-9+\/]{4}|[A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)$/;

  return base64Regex.test(str);
}



module.exports = {
  generateRandomString,
  generateRandomNumber,
  removeSpecialCharactersAndSpaces,
  generateSecureRandomSixDigit,
  getCurrentDateTimeInGMT8,
  filterAndFormatPhones,
  formatDate12Hour,
  formatDateWithoutTime,
  isValidDate,
  formatEncodeDate,
  generateRandomWords,
  isBase64
};
