const { checkoutService, mockCheckoutService } = require("../../helpers/checkout.service");
const QRCode = require("qrcode");
const fs = require("fs");
const path = require("path");
const OrderForm = require("../../models/OrderForm");

exports.checkout = async (req, res, next) => {
  try {
    const { customerId } = req;
    const { data } = req.body;

    const {
      shipping_type,
      payment_method,
      rpaf_payment,
      bank_payment,
      voucher_code,
      pickup_date,
      order_instructions,
      agent_code,
      transportify_shipping_fee,
      lalamove_shipping_fee,
      checkoutAddress,
      checkoutLatitude,
      checkoutLongitude,
      item_vouchers,
    } = data;

    const { note } = req.files;

    const attachmentFileName = note && Array.isArray(note) && note[0].filename ? note[0].filename : null;

    const serviceResponse = await checkoutService(customerId, {
      shipping_type,
      payment_method,
      buildcredit_payment: rpaf_payment,
      bank_payment,
      voucher_code,
      pickup_date,
      order_instructions,
      agent_code,
      transportify_shipping_fee,
      lalamove_shipping_fee,
      checkoutAddress,
      checkoutLatitude,
      checkoutLongitude,
      bank_transfer_attachment: attachmentFileName,
      item_vouchers,
    });

    res.status(200).json({ success: true, response: serviceResponse });
  } catch (err) {
    next(err);
  }
};

exports.mockCheckout = async (req, res, next) => {
  try {
    const { customerId } = req;
    const {
      shipping_type,
      payment_method,
      rpaf_payment,
      bank_payment,
      voucher_code,
      pickup_date,
      order_instructions,
      agent_code,
      transportify_shipping_fee,
      lalamove_shipping_fee,
      checkoutAddress,
      checkoutLatitude,
      checkoutLongitude,
      item_vouchers,
    } = req.body;

    const serviceResponse = await mockCheckoutService(customerId, {
      shipping_type,
      payment_method,
      buildcredit_payment: rpaf_payment,
      bank_payment,
      voucher_code,
      pickup_date,
      order_instructions,
      agent_code,
      transportify_shipping_fee,
      lalamove_shipping_fee,
      checkoutAddress,
      checkoutLatitude,
      checkoutLongitude,
      item_vouchers,
    });

    if (serviceResponse.error) {
      res.status(400).json({ success: false, message: serviceResponse.message });
    }
    res.status(200).json({ success: true, ...serviceResponse });
  } catch (err) {
    next(err);
  }
};

exports.generateQr = async (req, res, next) => {
  try {
    const { reference_no } = req.query;

    if (!reference_no) {
      return res.status(400).json({ error: "reference_no is required" });
    }

    const orderForm = await OrderForm.findOne({
      where: {
        reference_no,
      },
    });
    if (!orderForm) {
      return res.status(400).json({ error: "Invalid reference no" });
    }

    const qrCodeFilePath = path.join(__dirname, `${reference_no}.png`);
    await QRCode.toFile(qrCodeFilePath, reference_no);

    res.setHeader("Content-Disposition", `attachment; filename="${reference_no}.png"`);
    res.setHeader("Content-Type", "image/png");

    res.sendFile(qrCodeFilePath, (err) => {
      if (err) {
        next(err);
      } else {
        fs.unlinkSync(qrCodeFilePath);
      }
    });
  } catch (error) {
    next(error);
  }
};
