const OrderForm = require("../../models/OrderForm");

exports.updateOrderFormPaynamics = (req, res, next) => {
  const { payment_reference_number = null, payment_status = null } = req.body;
  const { orderFormId } = req.params;

  const secretKey = req.get("X-SECRET-KEY");

  if (!secretKey || secretKey !== process.env.SECRETKEY) {
    return res.status(401).json({ success: false, msg: "Not authorized." });
  }

  OrderForm.findByPk(orderFormId)
    .then((orderForm) => {
      if (!orderForm) {
        return res
          .status(200)
          .json({ success: false, msg: "Order form Id does not exists!" });
      }

      orderForm.payment_reference_number = payment_reference_number;
      orderForm.payment_status = payment_status;

      return orderForm.save();
    })
    .then((orderFormResult) => {
      res.status(200).json({
        success: true,
        msg: "Order updated successfully!",
        orderFormResult,
      });
    })
    .catch((err) => {
      next(err);
    });
};
