const Customers = require("../../models/Customers");
const marketplaceSettings = require('../../marketplace.json');
exports.selfDetail = (req, res, next) => {
  const { customerId } = req;

  Customers.findOne({
    where: {
      id: customerId,
    },
  })
    .then((customerDetail) => {
      if (customerDetail.file_2303 !== null && customerDetail.file_2303 !== "" && customerDetail.file_2303) {
        customerDetail.file_2303 = `https://api.buildhubware.com/public/file-2303/${customerDetail.file_2303}`;
      }
      if (customerDetail.client_facial_verification !== null && customerDetail.client_facial_verification !== "" && customerDetail.client_facial_verification) {
        customerDetail.client_facial_verification = `${marketplaceSettings.CLIENT_VERIFICATION_URL}${customerDetail.client_facial_verification}`;
      }
      if (customerDetail.client_signature !== null && customerDetail.client_signature !== "" && customerDetail.client_signature) {
        customerDetail.client_signature = `${marketplaceSettings.CLIENT_VERIFICATION_URL}${customerDetail.client_signature}`;
      }
      res.status(200).json({ success: true, customerDetail });
    })
    .catch((err) => {
      next(err);
    });
};
exports.updateSelf = async (req, res, next) => {
  const { customerId, impersonation } = req;
  const { data } = req.body;
  const {
    customerType,
    agentCode,
    agentName,
    hardwareName,
    firstName,
    lastName,
    email,
    phone,
    address,
    longitude,
    latitude,
  } = data;
  const { file_2303, client_facial_verification, client_signature } = req.files;

  const filterUpdateValues = (values) => {
    return Object.keys(values).reduce((acc, key) => {
      if (values[key] !== null && values[key] !== "" && values[key] !== undefined) {
        acc[key] = values[key];
      }
      return acc;
    }, {});
  };

  try {
    if (email && email !== null && email !== "") {
      const ownAccountDetails = await Customers.findByPk(customerId);
      let isNotChangingEmail = false;
      if (ownAccountDetails) {
        const oldEmail = ownAccountDetails.email;

        if (oldEmail === email) isNotChangingEmail = true;
      }

      if (!isNotChangingEmail) {
        const existingEmail = await Customers.findOne({
          where: {
            email,
          },
        });

        if (existingEmail) return res.status(400).json({ success: false, message: "Email already exists." });
      }
    }

    let updateValues = {};
    if (impersonation) {
      updateValues = {
        type: customerType,
        agent: agentName,
        hardware_name: hardwareName,
        phone,
        address,
        longitude,
        latitude,
      };
    } else {
      updateValues = {
        type: customerType,
        agent: agentName,
        hardware_name: hardwareName,
        first_name: firstName,
        last_name: lastName,
        email,
        phone,
        address,
        longitude,
        latitude,
        file_2303: file_2303 ? file_2303[0].filename : undefined,
        client_facial_verification: client_facial_verification ? client_facial_verification[0].filename : undefined,
        client_signature: client_signature ? client_signature[0].filename : undefined,
        is_completed_profile: address ? false : true
      };
      // if (client_facial_verification || client_signature) {
      //   updateValues.is_completed_profile = false;
      // }
    }


    updateValues = filterUpdateValues(updateValues);

    const updatedCustomerData = await Customers.update(updateValues, {
      where: {
        id: customerId,
      },
    });
    res.status(200).json({ success: true, customer: updateValues });
  } catch (err) {
    next(err);
  }
};
