const Trucks = require("../models/Trucks");
const jwt = require("jsonwebtoken");
const errorHandler = require("../util/errorHandler");

// Create a new Truck
exports.createTruck = async (req, res, next) => {
    try {
        const {
            logistics_id,
            group_id,
            current_lat,
            current_long,
            driver_id,
            truck_plate_no,
            truck_type
        } = req.body;
  
        Trucks.create({
            logistics_id: logistics_id,
            group_id: group_id,
            current_lat: current_lat,
            current_long: current_long,
            driver_id: driver_id,
            truck_plate_no: truck_plate_no,
            truck_type: truck_type
        });
  
        res.status(201).json({ success: "Truck successfully created!" });
    } catch (err) {
        next(err);
    }
  };

  // Get all Trucks
exports.getAllTruck = async (req, res, next) => {
    try {
      const trucks = await Trucks.findAll();
  
      const trucksResponse = trucks.map(truck = ({
            logistics_id,
            group_id,
            current_lat,
            current_long,
            driver_id,
            truck_plate_no,
            truck_type
     }) => ({
            logistics_id: logistics_id,
            group_id: group_id,
            current_lat: current_lat,
            current_long: current_long,
            driver_id: driver_id,
            truck_plate_no: truck_plate_no,
            truck_type: truck_type
     })
     
      );
      
      res.status(200).json(trucksResponse);
    } catch (error) {
      next(error)
    }
};

// Get Trucks by Id
exports.getTruckId = async (req, res, next) => {
    const { TruckId } = req.params;
  
    try {
      const trucks = await Trucks.findByPk(TruckId);
  
      if (!trucks) {
        return res.status(404).json({ error: 'Truck not found' });
      }
  
      res.status(200).json(trucks);
    } catch (error) {
        next(error)
    }
  };

  // Delete Truck
exports.deleteTruckId = async (req, res, next) => {
    const { TruckId } = req.params;
  
    try {
      const trucks = await Trucks.findByPk(TruckId);
  
      if (!trucks) {
        return res.status(404).json({ error: 'Truck not found' });
      }
  
      await trucks.destroy();
  
      res.status(201).json({ success: "The Truck ID has been successfully Deleted" });
    } catch (error) {
      next(error)
    }
  };

  // Update Truck by ID
exports.updateTruck = async (req, res, next) => {
    const { TruckId } = req.params;
    try {
      const trucks = await Trucks.findByPk(TruckId);
  
      if (!trucks) {
        return res.status(404).json({ error: 'Truck not found' });
      }
  
      const { logistics_id, group_id, current_lat, current_long, driver_id,truck_plate_no,truck_type} = req.body;
  
      await trucks.update({
            logistics_id,
            group_id,
            current_lat,
            current_long,
            driver_id,
            truck_plate_no,
            truck_type
      });
  
      res.status(200).json(trucks);
    } catch (error) {
      next(error)
    }
  };