const RpafAdminPayment = require("../models/RpafAdminPayment");
const jwt = require("jsonwebtoken");
const errorHandler = require("../util/errorHandler");
const multer = require('multer');

// Get all products
exports.getAllRpafAdminPayment = async (req, res) => {
  try {
    const rpafap = await RpafAdminPayment.findAll();

    const rpafAPresponse = rpafap.map(rpafAP = ({
        customer_id,
        order_no,
        invoice_amount,
        bal,
        amount_paid,
        cwt_amount,
        net_amount,
   }) => ({
        customer_id:customer_id,
        order_no:order_no,
        invoice_amount:invoice_amount,
        bal:bal,
        amount_paid:amount_paid,
        cwt_amount:cwt_amount,
        net_amount:net_amount,
   })
   
   );
   res.status(200).json(rpafAPresponse);
  }
   catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

 // Get a specific product by ID
 exports.getrpafAPId =  async (req, res) => {
    const { rpafAPID } = req.params;
  
    try {
      const rpafAP = await RpafAdminPayment.findByPk(rpafAPID);
  
      if (!rpafAP) {
        return res.status(404).json({ error: "RpafAdminPayment ID not found" });
      }
  
      res.status(200).json(rpafAP);
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  };

  exports.deleterpafAP = (req, res) => {
    const { rpafAPID } = req.params;
  
    try {
      const deletedRowCount = RpafAdminPayment.destroy({
        where: {
          id: rpafAPID,
        },
      });
  
      if (deletedRowCount === 0) {
        return res.status(404).json({ error: "Rpaf-Admin-Payment not found" });
      }
  
      res.status(204).send();
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: "Internal Server Error" });
    }
  };

  //Create
  exports.createRpafAP = (req, res, next) => {
    try {
        const { data } = req.body;
        const {
            customerID,
            invoice_amount,
            bal,
            amount_paid,
            cwt_amount,
            net_amount,
        } = data;


        if (!customerID) {
            return errorHandler("Customer ID is missing from the request.", 400);
        }

        const order_no = "ORD" + Math.random().toString(36).substring(2, 10).toUpperCase();

        RpafAdminPayment.findOne({
            where: {
                customer_id: customerID,
            },
        })
            .then((rpafadminpayment) => {
                if (rpafadminpayment) {
                    return errorHandler("RpafAdminPayment ID already exists!", 401);
                }

                return new RpafAdminPayment({
                    customer_id: customerID,
                    order_no: order_no,
                    invoice_amount: invoice_amount,
                    bal: bal,
                    amount_paid: amount_paid,
                    cwt_amount: cwt_amount,
                    net_amount: net_amount,
                }).save();
            })
            .then(() => {
                res.status(201).json({ success: true });
            })
            .catch((err) => {
                next(err);
            });
    } catch (error) {
        next(error);
    }
};

exports.updateRpafAP =  (req, res) => {
  const { rpafAPID } = req.params; // id
  const { data } = req.body;
  const {     
    invoice_amount,
    bal,
    amount_paid,
    cwt_amount,
    net_amount,
  } = data;

  RpafAdminPayment.findOne ({
      where:{
          id: rpafAPID,
            },
  })
  .then ((rpafap) => {
      if(!rpafap) {
          return errorHandler("Rpaf Payment Head ID does not exists!", 404);
      }
      
      rpafap.invoice_amount = invoice_amount,
      rpafap.bal = bal,
      rpafap.amount_paid = amount_paid;
      rpafap.cwt_amount = cwt_amount;
      rpafap.net_amount = net_amount;

      return rpafap.save();
  })
  .then(() => {
      res.status(200).json({ success: true });
  })
};