const OrderFormDetails = require("../models/OrderFormDetails");
const jwt = require("jsonwebtoken");
const errorHandler = require("../util/errorHandler");
const multer = require('multer');

exports.createOrderFormDetails = (req, res, next) => {
  const { data } = req.body;
  const {
      order_form_id, 
      product_id,
      variant,
      quantity,
      discounted_price,
      price,
      amount,
      rated,
      has_sub_variation_chosen,
      product_variation_id,
      product_sub_variation_id
  } = data;

  if (!order_form_id) {
      return errorHandler("order_form_id is missing from the request.", 400);
  }

  OrderFormDetails.findOne({ 
      where: {
          order_form_id: order_form_id,
      },
  })
  .then((orderformdetails) => {
      if (orderformdetails) {
          return errorHandler("OrderFormDetails ID already exists!", 401);
      }
      
      return new OrderFormDetails({
          order_form_id: order_form_id, 
          product_id: product_id,
          variant: variant,
          quantity: quantity,
          discounted_price: discounted_price,
          price: price,
          amount: amount,
          rated: rated,
          has_sub_variation_chosen: has_sub_variation_chosen,
          product_variation_id: product_variation_id,
          product_sub_variation_id: product_sub_variation_id
      }).save();
  })
  .then(() => {
      res.status(201).json({ success: true });
  })
  .catch((err) => {
      next(err);
  });
};

exports.updateOrderFormDetails =  (req, res) => {
  const { OrderFormDetailsID } = req.params; // id
  const { data } = req.body;
  const { 
      variant,
      quantity,
      discounted_price,
      price,
      amount,
      rated,
      has_sub_variation_chosen,
      product_variation_id,
      product_sub_variation_id
  } = data;

  OrderFormDetails.findOne ({
      where:{
          id: OrderFormDetailsID,
      },
  })
  .then ((orderformdetails) => {
      if(!orderformdetails) {
          return errorHandler("orderformdetails ID does not exist!", 404);
      } 
      orderformdetails.variant = variant;
      orderformdetails.quantity = quantity;
      orderformdetails.discounted_price = discounted_price;
      orderformdetails.price = price;
      orderformdetails.amount = amount;
      orderformdetails.rated = rated;
      orderformdetails.has_sub_variation_chosen = has_sub_variation_chosen;
      orderformdetails.product_variation_id = product_variation_id;
      orderformdetails.product_sub_variation_id = product_sub_variation_id;

      return orderformdetails.save();
  })
  .then(() => {
      res.status(200).json({ success: true });
  })
  .catch((err) => {
      next(err);
  });
};

exports.getOrderFormDetails = async (req, res) => {
  try {
    const orderformdetails = await OrderFormDetails.findAll();

    const orderformdetailsresponse = orderformdetails.map(orderformdetail => ({
      order_form_details_id: orderformdetail.id,
      order_form_id: orderformdetail.order_form_id,
      product_id: orderformdetail.product_id,
      variant: orderformdetail.variant,
      quantity: orderformdetail.quantity,
      discounted_price: orderformdetail.discounted_price,
      price: orderformdetail.price,
      amount: orderformdetail.amount,
      rated: orderformdetail.rated,
      reference_no: orderformdetail.OrderForm ? orderformdetail.OrderForm.reference_no : null,
      has_sub_variation_chosen: orderformdetail.has_sub_variation_chosen,
      product_variation_id: orderformdetail.product_variation_id,
      product_sub_variation_id: orderformdetail.product_sub_variation_id

    }));
    
    res.status(200).json(orderformdetailsresponse);
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

exports.getOrderFormDetailsById = async (req, res) => {
  const { OrderFormDetailsID } = req.params;

  try {
    const order_form_details = await OrderFormDetails.findByPk(OrderFormDetailsID);

    if (!order_form_details) {
      return res.status(404).json({ error: "Order_form_details not found" });
    }

    const response = {
      order_form_details_id: order_form_details.id,
      order_form_id: order_form_details.order_form_id,
      product_id: order_form_details.product_id,
      variant: order_form_details.variant,
      quantity: order_form_details.quantity,
      discounted_price: order_form_details.discounted_price,
      price: order_form_details.price,
      amount: order_form_details.amount,
      rated: order_form_details.rated,
      reference_no: order_form_details.OrderForm ? order_form_details.OrderForm.reference_no : null,
      has_sub_variation_chosen: order_form_details.has_sub_variation_chosen,
      product_variation_id: order_form_details.product_variation_id,
      product_sub_variation_id: order_form_details.product_sub_variation_id
    };

    res.status(200).json(response);
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};

exports.deleteOrderFormDetailsById = (req, res) => {
  const { OrderFormDetailsID } = req.params;

  try {
    const deletedRowCount = OrderFormDetails.destroy({
      where: {
        id: OrderFormDetailsID,
      },
    });

    if (deletedRowCount === 0) {
      return res.status(404).json({ error: "OrderFormDetails not found" });
    }

    res.status(204).send();
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: "Internal Server Error" });
  }
};
