const jwt = require("jsonwebtoken");
const errorHandler = require("../util/errorHandler");
const LogisticsUser = require("../models/LogisticsUser");

// Create a Logistics User
exports.createLogisticsUser = async (req, res, next) => {
    try {
        const {
            logistics_id,
            Username,
            password,
            Fullname,
            email_address,
            roles
        } = req.body;
  
        LogisticsUser.create({
            logistics_id: logistics_id,
            Username: Username,
            password: password,
            Fullname: Fullname,
            email_address: email_address,
            roles: roles,
        });
  
        res.status(201).json({ success: "Logistic User successfully created!" });
    } catch (err) {
        next(err);
    }
  };

  // Get all Logistics User
exports.getAllLogisticsUser = async (req, res, next) => {
    try {
      const logisticUser = await LogisticsUser.findAll();
  
      const logisticsUserResponse = logisticUser.map(logistics_user = ({
            logistics_id,
            Username,
            password,
            Fullname,
            email_address,
            roles
     }) => ({
            logistics_id: logistics_id,
            Username: Username,
            password: password,
            Fullname: Fullname,
            email_address: email_address,
            roles: roles,
     })
     
      );
      
      res.status(200).json(logisticsUserResponse);
    } catch (error) {
      next(error)
    }
};

// Get Logistics by Id
exports.getLogisticsUserId = async (req, res, next) => {
    const { LogisticUserId } = req.params;
  
    try {
      const logisticUser = await LogisticsUser.findByPk(LogisticUserId);
  
      if (!logisticUser) {
        return res.status(404).json({ error: 'Logistic User not found' });
      }
  
      res.status(200).json(logisticUser);
    } catch (error) {
        next(error)
    }
  };

  // Delete Logistics User
exports.deleteLogisticsUser = async (req, res, next) => {
    const { LogisticUserId } = req.params;
  
    try {
      const logisticUser = await LogisticsUser.findByPk(LogisticUserId);
  
      if (!logisticUser) {
        return res.status(404).json({ error: 'Logistic User not found' });
      }
  
      await logisticUser.destroy();
  
      res.status(201).json({ success: "The Logistic User ID has been successfully Deleted" });
    } catch (error) {
      next(error)
    }
  };

  // Update Logistic User by ID
exports.updateLogisticUser = async (req, res, next) => {
    const { LogisticUserId } = req.params;
    try {
      const logisticUser = await LogisticsUser.findByPk(LogisticUserId);
  
      if (!logisticUser) {
        return res.status(404).json({ error: 'Logistic User not found' });
      }
  
      const { logistics_id, Username, password, Fullname, email_address, roles } = req.body;
  
      await logisticUser.update({
            logistics_id,
            Username,
            password,
            Fullname,
            email_address,
            roles
      });
  
      res.status(200).json(logisticUser);
    } catch (error) {
      next(error)
    }
  };

  