const HardwareCredit = require("../models/HardwareCredit");
const errorHandler = require("../util/errorHandler");

exports.createHardwareCredit = (req, res, next) => {
    const { customerId } = req;
    const {
        sellerId,
        amount,
        status
    } = req.body;

    const referenceNo = "RPREF" + Math.floor(Math.random() * 1000000000).toString();

    HardwareCredit.findOne({
        where: {
            customer_id: customerId,
        },
    })
    .then((hardware) => {
        if(hardware) {
            return errorHandler("Customer ID already exists!", 404);
        }

        return new HardwareCredit({
            seller_id: sellerId,
            customer_id: customerId,
            reference_no: referenceNo,
            amount: amount,
            status: status
        }).save();
    })
    .then(() => {
        res.status(201).json({ success: true });
    })
    .catch((err) => {
        next(err);
    });
};

exports.updateHardwareCredit = (req, res, next) => {
    const { referenceNo } = req.params;
    const {
        sellerId,
        amount,
        status
    } = req.body;

    HardwareCredit.findOne({
        where: {
            reference_no: referenceNo,
        },
    })
    .then((hardware) => {
        if (!hardware) {
            return errorHandler("ReferenceNo does not exists!", 404);
        }

        hardware.seller_id = sellerId;
        hardware.amount = amount;
        hardware.status = status;

        return hardware.save(); 
    })
    .then(() => {
        res.status(200).json({ success: true });
    })
    .catch((err) => {
        next(err); 
    });
};

exports.deleteHardwareCredit = (req, res, next) => {
    const { referenceNo } = req.params;

    HardwareCredit.findOne({
        where: {
            reference_no: referenceNo,
        },
    })
    .then((hardware) => {
        if(!hardware) {
            return errorHandler("ReferenceNo does not exists!", 404);
        }

        return hardware.destroy();
    })
    .then(() => {
        res.status(204).send();
    })
    .catch((err) => {
        next(err);
    })
};

exports.findAllHardwareCredit = (req, res, next) => {
    HardwareCredit.findAll()
    .then((hardware) => {
        const result = hardware.map((hardware) => ({
            id: hardware.id,
            sellerId: hardware.seller_id,
            customerId: hardware.customer_id,
            referenceNo: hardware.referenceNo,
            amount: hardware.amount,
            status: hardware.status
        }));
        return res.status(200).json({ success: true, result });
    })
    .catch((err) => {
        next(err);
    });
};

exports.findHardwareCreditById = (req, res, next) => {
    const { referenceNo } = req.params;

    HardwareCredit.findOne({
        where: {
            reference_no: referenceNo,
        },
    })
    .then((hardware) => {
        if (!hardware) {
            return errorHandler("ReferenceNo does not exists!", 404);
        }
        
        const result = {
            id: hardware.id,
            sellerId: hardware.seller_id,
            customerId: hardware.customer_id,
            referenceNo: hardware.reference_no,
            amount: hardware.amount,
            status: hardware.status
        };

        return res.status(200).json({ success: true, hardwareCredit: result });
    })
    .catch((err) => {
        next(err);
    });
};