const OrderList = require("../models/OrderList");
const errorHandler = require("../util/errorHandler");

exports.cancelOrder = (req, res, next) => {
    const { customerId } = req;
    const { referenceNo } = req.params;
    const { status } = req.body;

    OrderList.findOne({
        where: {
            customer_id: customerId,
            reference_no: referenceNo,
        },
    })
    .then((cancel) => {
        if(!cancel) {
            return errorHandler("Reference Number does not exists!", 404);
        }
        cancel.status = status;

        return cancel.save();
    })
    .then(() => {
        res.status(200).json({ success: true });
    })
    .catch((err) => {
        next(err);
    });
};