const whispir = require("../../helpers/whispir");
const smsTemplates = require("../../helpers/sms-no-templates/sms-no-templates");
const OrderForm = require("../../models/OrderForm");
const Customers = require("../../models/Customers");
const SellersCompany = require("../../models/SellersCompany");
const { filterAndFormatPhones, formatDate12Hour } = require("../../helpers/common");
exports.customMessage = async (req, res, next) => {
  const { custom, recipientNumber } = req.body;

  const whispirReqBody = {
    customTemplate: custom,
    recipientNumber,
  };
  try {
    const whispirResponse = await whispir.messaging.singleMessage(whispirReqBody, "custom");
    res.status(200).json({ success: true, msg: "SMS sent successfully" });
  } catch (err) {
    next(err);
  }
};

exports.orderVerified = async (req, res, next) => {
  const { reference_no } = req.body;

  if (!reference_no) res.status(401).json({ success: false, message: "Missing reference no!" });

  try {
    const orderForm = await OrderForm.findOne({
      where: {
        reference_no,
      },
      attributes: ["reference_no", "customer_id", "shipping_type"],
      include: [
        {
          model: Customers,
          as: "customer_detail",
          attributes: ["first_name", "last_name", "hardware_name", "phone", "phone_2", "phone_3"],
        },
        {
          model: SellersCompany,
          as: "sellers_company_details",
          attributes: ["id", "phone_number_primary", "phone_number_optional", "phone_number_optional_2"],
        },
      ],
    });

    const customerPhones = filterAndFormatPhones([
      orderForm?.customer_detail?.phone,
      orderForm?.customer_detail?.phone_2,
      orderForm?.customer_detail?.phone_3,
    ]);

    const sellerPhones = filterAndFormatPhones([
      orderForm?.sellers_company_details?.phone_number_primary,
      orderForm?.sellers_company_details?.phone_number_optional,
      orderForm?.sellers_company_details?.phone_number_optional_2,
    ]);

    const customerSmsTemplate = smsTemplates.orderVerified(
      `${orderForm?.customer_detail?.first_name} ${orderForm?.customer_detail?.last_name}`,
      reference_no
    );

    const sellersSmsTemplate = smsTemplates.sellerWarehouseMenSmsTemplateOrderPlaced(
      `${orderForm?.customer_detail?.first_name} ${orderForm?.customer_detail?.last_name}`,
      orderForm?.customer_detail?.hardware_name,
      reference_no,
      formatDate12Hour(new Date()),
      orderForm?.shipping_type === "Standard Shipping" || orderForm?.shipping_type === "Hardware Shipping"
    );

    if (customerPhones.length > 0) {
      const whispirText = await whispir.messaging.singleMessage(
        {
          recipientNumber: customerPhones.join(","),
          customTemplate: customerSmsTemplate,
        },
        "custom"
      );
    }

    if (sellerPhones.length > 0) {
      const whispirText = await whispir.messaging.singleMessage(
        {
          recipientNumber: sellerPhones.join(","),
          customTemplate: sellersSmsTemplate,
        },
        "custom"
      );
    }

    res.status(200).json({ success: true });
  } catch (err) {
    next(err);
  }
};
