const statementBreakdown = (statementBreakdown) => {
  let html = ``;

  for (const breakdown of statementBreakdown) {
    html += `
          <tr>
            <td style="font-size: .8rem"><strong>${breakdown?.order_reference_no ?? "N/A"}</strong></td>
            <td>${breakdown?.order_total_amount ?? "N/A"}</td>
            <td>${breakdown?.payments_total ?? "N/A"}</td>
            <td>${breakdown?.unpaid_balance ?? "N/A"}</td>
            <td>${breakdown?.date ?? "N/A"}</td>
            <td>${breakdown?.due_date ?? "N/A"}</td>
            <td>${breakdown?.date_delivered ?? "N/A"}</td>
            <td>${breakdown?.remarks ?? "N/A"}</td>
          </tr>
          <tr>
            <td colspan="8">
              <table class="order-details-table">
                <thead>
                  <tr>
                    <th>Product Name</th>
                    <th>Quantity</th>
                  </tr>
                </thead>
                <tbody>
                  ${
                    Array.isArray(breakdown?.order_form_details)
                      ? breakdown.order_form_details
                          .map(
                            (detail) => `
                      <tr>
                        <td>${detail?.product?.menu ?? "N/A"}</td>
                        <td>${detail?.quantity ?? "N/A"}</td>
                      </tr>
                    `
                          )
                          .join("")
                      : `<tr><td colspan="4">No order details available</td></tr>`
                  }
                </tbody>
              </table>
            </td>
          </tr>
        `;
  }

  return html;
};

const createStatementPDF = async (data, image) => {
  // Your HTML content
  const htmlContent = `
      <!DOCTYPE html>
    <html lang="en">
    <head>
      <meta charset="UTF-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0" />
      <title>BuildCredit Statement of Account</title>
      <style>
        body {
          margin: 0;
          padding: 0;
          font-family: Arial, sans-serif;
          color: #333;
        }
        .header {
          display: flex;
          justify-content: space-between;
          padding: 20px;
          border-bottom: 3px solid #d32f2f; /* Red color */
        }
        .header-logo img {
          width: 150px;
          height: auto;
        }
        .header-detail {
          text-align: right;
          font-size: 12px;
        }
        .main-content {
          display: flex;
          flex-direction: column;
          align-items: center;
          padding: 20px;
          border-bottom: 2px solid #ddd;
        }
        .titles h3,
        .titles h4 {
          margin: 0;
        }
        .titles h3 {
          color: #d32f2f; /* Red color */
          margin-bottom: 8px;
        }
        .titles h4 {
          color: #555;
        }
        .date-time {
          text-align: right;
          padding: 0 20px 20px;
          font-size: 12px;
        }
        .main-table,
        .order-breakdown-table {
          padding: 0 20px;
          margin-top: 20px;
        }
        table {
          width: 100%;
          border-collapse: collapse;
          font-size: 10px;
        }
        th,
        td {
          padding: 10px;
          font-size: 10px;
          text-align: left;
        }
        th:not(.order-details-table th) {
          background-color: #d32f2f; /* Red color */
          color: white;
          font-size: 10px;
        }
        .order-details-table {
          border-bottom: 2px solid black;
        }
        .order-details-table th {
          font-size: 10px;
        }
        tr:nth-child(even) {
          background-color: #f9f9f9;
        }
        .order-breakdown-table {
          page-break-before: always;
        }
    
        table tr {
          page-break-inside: avoid;
        }
        @page {
          margin: 20mm;
        }
        body {
          margin: 0;
        }
        table {
          table-layout: fixed;
          word-wrap: break-word;
        }
        th,
        td {
          padding: 5px;
        }
      </style>
    </head>
    <body>
      <header class="header">
        <div class="header-logo">
          <img src="data:image/jpeg;base64,${image}" alt="BuildCredit Logo" />
        </div>
        <div class="header-detail">
          <p>Branch Office: 1501 The Centerpoint</p>
          <p>Condo., Julia Vargas Ave., Ortigas Center,</p>
          <p>Pasig, Metro Manila</p>
        </div>
      </header>
    
      <div class="main-content">
        <div class="titles">
          <h3>BUILDCREDIT</h3>
          <h4>STATEMENT OF ACCOUNT</h4>
        </div>
      </div>
    
      <div class="date-time">
        <p>Date and Time: ${data.dateNTime}</p>
      </div>
    
      <div class="main-table">
        <table>
          <thead>
            <tr>
              <th>Company Name</th>
              <th>Status</th>
              <th>Credit Terms</th>
              <th>Build Credit Limit</th>
              <th>Account Balance</th>
              <th>Available Line</th>
              <th>PDC Sent & Received</th>
              <th>Account Balance Less PDC</th>
              <th>Available Line Plus PDC (SAP)</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>${data.companyName}</td>
              <td>${data.buildcreditStatus}</td>
              <td>${data.creditTerms}</td>
              <td>${data.creditLimit}</td>
              <td>${data.accountBalance}</td>
              <td>${data.availableLine}</td>
              <td>${data.pdcSent}</td>
              <td>${data.abLessPdc}</td>
              <td>${data.alPlusPdc}</td>
            </tr>
          </tbody>
        </table>
      </div>
    
      <div class="order-breakdown-table titles">
        <div class="main-content">
          <h4>Statement Breakdown</h4>
        </div>
        <table>
          <thead>
            <tr>
              <th>Reference Number</th>
              <th>Order Total Amount</th>
              <th>Total Payments Made</th>
              <th>Unpaid Balance</th>
              <th>Date</th>
              <th>Due Date</th>
              <th>Actual Date Delivered/Received</th>
              <th>Remarks</th>
            </tr>
          </thead>
          <tbody>
            ${statementBreakdown(data.statementBreakdown)}
          </tbody>
        </table>
      </div>
    </body>
    </html>
    
    `;

  return htmlContent;
};

module.exports = createStatementPDF;
