const AdminAuthorizationToken = require("../../models/AdminAuthorizationToken");

function generateRandomString(length) {
  const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  let result = "";
  const charactersLength = characters.length;

  for (let i = 0; i < length; i++) {
    result += characters.charAt(Math.floor(Math.random() * charactersLength));
  }

  return result;
}
exports.generateRandomToken = async (req, res, next) => {
  try {
    const { admin_user_id } = req.query;

    if (!admin_user_id) return res.status(200).json({ success: false, message: "Invalid Admin User ID" });
    const randomString = generateRandomString(50);
    const adminAuthToken = await AdminAuthorizationToken.create({
      admin_user_id,
      token: randomString,
    });

    res.status(200).json({ success: true, token: randomString });
  } catch (err) {
    next(err);
  }
};
